---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Recovery Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestCatRecoveryAction.java` 行68-213
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行9

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/recovery と GET /_cat/recovery/{index} | E-01 行72 | ○ |
| C-02 | RecoveryRequest を使用 | E-01 行88 | ○ |
| C-03 | detailed パラメータ（デフォルト: false） | E-01 行90 | ○ |
| C-04 | active_only パラメータ（デフォルト: false） | E-01 行91 | ○ |
| C-05 | 26カラムの定義 | E-01 行105-132 | ○ |
| C-06 | CollectionUtil.introSort でシャードIDソート | E-01 行156-169 | ○ |
| C-07 | ソースノードがnullの場合 "n/a" 表示 | E-01 行182-183 | ○ |
| C-08 | スナップショットリカバリの場合のみ repository/snapshot 表示 | E-01 行186-195 | ○ |
| C-09 | files_percent のフォーマット %1.1f%% | E-01 行198 | ○ |
| C-10 | bytes は ByteSizeValue で表示 | E-01 行200-203 | ○ |
| C-11 | translog 統計の表示 | E-01 行204-206 | ○ |
| C-12 | start_time/stop_time は ISO8601形式 | E-01 行175,177 | ○ |
| C-13 | リカバリタイプは toLowerCase | E-01 行180 | ○ |
| C-14 | buildRecoveryTable は public メソッド | E-01 行144 | ○ |
| C-15 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの裏付けあり

## 6) レビュアーチェックリスト（最小）
- [ ] 26カラムの定義がソースコードと一致しているか
- [ ] スナップショットリカバリの条件分岐が正確か
- [ ] ソートの比較ロジックが正しいか
